<?php
	include "../../conn.php";
			
	header('Content-Type: application/json; charset=utf-8');
	header('Strict-Transport-Security: max-age=31536000');
	header('Access-Control-Allow-Headers: Origin, X-Requested-With, Content-Type, Accept, Authorization');
	header('Access-Control-Allow-Credentials: true');
	$origin = isset($_SERVER['HTTP_ORIGIN']) ? $_SERVER['HTTP_ORIGIN'] : '';
	header('Access-Control-Allow-Origin: ' . $origin);
	header('vary: Origin');
	
	date_default_timezone_set("Asia/Kolkata");
	$shnunc = date("Y-m-d H:i:s");
	$res = [
		'code' => 11,
		'msg' => 'Method not allowed',
		'msgCode' => 12,
		'serviceNowTime' => $shnunc,
	];
	$shonubody = file_get_contents("php://input");
	$shonupost = json_decode($shonubody, true);
	if ($_SERVER['REQUEST_METHOD'] != 'GET') {		
		if (isset($shonupost['language']) && isset($shonupost['random']) && isset($shonupost['signature']) && isset($shonupost['timestamp'])) {
			$language = htmlspecialchars(mysqli_real_escape_string($conn, $shonupost['language']));
			$random = htmlspecialchars(mysqli_real_escape_string($conn, $shonupost['random']));
			$signature = htmlspecialchars(mysqli_real_escape_string($conn, $shonupost['signature']));
			$shonustr = '{"language":'.$language.',"random":"'.$random.'"}';
			$shonusign = strtoupper(md5($shonustr));
			if($shonusign == $signature){				
$data['popular']['platformList'] = [

    [
        'vendorId' => '20',
        'gameCode' => 'a04d1f3eb8ccec8a4823bdf18e3f0e84',
        'gameNameEn' => 'Aviator',
        'imgUrl' => 'https://pub-628304d7b25d454abf303bfafba6a2e0.r2.dev/ALADDINN/gamelogo/SPRIBE/22001.png',
        'imgUrl2' => '',
        'winOdds' => 93.46
    ],
    [
        'vendorId' => '2',
        'gameCode' => 'fb33a6613e5ba5b8e42f035fbd4e103d',
        'gameNameEn' => 'Zeus M',
        'imgUrl' => 'https://pub-628304d7b25d454abf303bfafba6a2e0.r2.dev/ALADDINN/gamelogo/CQ9/125.png',
        'imgUrl2' => '',
        'winOdds' => 89.18
    ],
    [
        'vendorId' => '6',
        'gameCode' => 'b560b7c42bd29f7d0cda06485a3c4af5',
        'gameNameEn' => 'Lucky Seven',
        'imgUrl' => 'https://pub-628304d7b25d454abf303bfafba6a2e0.r2.dev/ALADDINN/gamelogo/JDB/14027.png',
        'imgUrl2' => '',
        'winOdds' => 80.49
    ],
    [
        'vendorId' => '18',
        'gameCode' => '109',
        'gameNameEn' => 'Fortune Gems',
        'imgUrl' => 'https://pub-628304d7b25d454abf303bfafba6a2e0.r2.dev/ALADDINN/gamelogo/JILI/109.png',
        'imgUrl2' => '',
        'winOdds' => 92.09
    ],
    [
        'vendorId' => '18',
        'gameCode' => '664fba4da609ee82b78820b1f570f4ad',
        'gameNameEn' => 'Fortune Gems 2',
        'imgUrl' => 'https://pub-628304d7b25d454abf303bfafba6a2e0.r2.dev/ALADDINN/gamelogo/JILI/223.png',
        'imgUrl2' => '',
        'winOdds' => 85.62
    ]
];
$data['popular']['clicksTopList'] = [
    [
        'vendorId' => '18',
        'gameCode' => 'db249defce63610fccabfa829a405232',
        'gameNameEn' => 'Money Coming',
        'imgUrl' => 'https://pub-628304d7b25d454abf303bfafba6a2e0.r2.dev/ALADDINN/gamelogo/JILI/51.png',
        'imgUrl2' => '',
        'winOdds' => 83.49
    ],
    [
        'vendorId' => '18',
        'gameCode' => 'a990de177577a2e6a889aaac5f57b429',
        'gameNameEn' => 'Fortune Gems',
        'imgUrl' => 'https://pub-628304d7b25d454abf303bfafba6a2e0.r2.dev/ALADDINN/gamelogo/JILI/109.png',
        'imgUrl2' => '',
        'winOdds' => 92.09
    ],
    [
        'vendorId' => '18',
        'gameCode' => '664fba4da609ee82b78820b1f570f4ad',
        'gameNameEn' => 'Fortune Gems 2',
        'imgUrl' => 'https://pub-628304d7b25d454abf303bfafba6a2e0.r2.dev/ALADDINN/gamelogo/JILI/223.png',
        'imgUrl2' => '',
        'winOdds' => 85.62
    ],
    [
        'vendorId' => '2',
        'gameCode' => '7057b9185aaee613216ff18352ad1c2f',
        'gameNameEn' => 'Hot Spin',
        'imgUrl' => 'https://pub-628304d7b25d454abf303bfafba6a2e0.r2.dev/ALADDINN/gamelogo/CQ9/19.png',
        'imgUrl2' => '',
        'winOdds' => 82.73
    ],
    [
        'vendorId' => '4',
        'gameCode' => 'daabc9426034dc78ce3c6b5c5bb1c3d6',
        'gameNameEn' => 'Wildfire Wins',
        'imgUrl' => 'https://pub-628304d7b25d454abf303bfafba6a2e0.r2.dev/ALADDINN/gamelogo/MG/SMG_wildfireWins.png',
        'imgUrl2' => '',
        'winOdds' => 92.56
    ],
    [
        'vendorId' => '6',
        'gameCode' => 'b560b7c42bd29f7d0cda06485a3c4af5',
        'gameNameEn' => 'Lucky Seven',
        'imgUrl' => 'https://pub-628304d7b25d454abf303bfafba6a2e0.r2.dev/ALADDINN/gamelogo/JDB/14027.png',
        'imgUrl2' => '',
        'winOdds' => 80.49
    ],
    [
        'vendorId' => '18',
        'gameCode' => '28bc4a33c985ddce6acd92422626b76f',
        'gameNameEn' => 'Charge Buffalo',
        'imgUrl' => 'https://pub-628304d7b25d454abf303bfafba6a2e0.r2.dev/ALADDINN/gamelogo/JILI/47.png',
        'imgUrl2' => '',
        'winOdds' => 80.79
    ],
    [
        'vendorId' => '18',
        'gameCode' => '8c62471fd4e28c084a61811a3958f7a1',
        'gameNameEn' => 'Crazy777',
        'imgUrl' => 'https://pub-628304d7b25d454abf303bfafba6a2e0.r2.dev/ALADDINN/gamelogo/JILI/35.png',
        'imgUrl2' => '',
        'winOdds' => 88.23
    ],
    [
        'vendorId' => '18',
        'gameCode' => 'bdfb23c974a2517198c5443adeea77a8',
        'gameNameEn' => 'Super Ace',
        'imgUrl' => 'https://pub-628304d7b25d454abf303bfafba6a2e0.r2.dev/ALADDINN/gamelogo/JILI/49.png',
        'imgUrl2' => '',
        'winOdds' => 82.79
    ],
    [
        'vendorId' => '2',
        'gameCode' => '8beb52f0188e78a2f39cd5ea63e22232',
        'gameNameEn' => 'OneShotFishing',
        'imgUrl' => 'https://pub-628304d7b25d454abf303bfafba6a2e0.r2.dev/ALADDINN/gamelogo/CQ9/AT01.png',
        'imgUrl2' => '',
        'winOdds' => 88.06
    ],
    [
        'vendorId' => '18',
        'gameCode' => '71c68a4ddb63bdc8488114a08e603f1c',
        'gameNameEn' => 'Happy Fishing',
        'imgUrl' => 'https://pub-628304d7b25d454abf303bfafba6a2e0.r2.dev/ALADDINN/gamelogo/JILI/82.png',
        'imgUrl2' => '',
        'winOdds' => 87.31
    ],
    [
        'vendorId' => '6',
        'gameCode' => '16b1418fe87a6fa5628eec8cb40da056',
        'gameNameEn' => 'Billionaire',
        'imgUrl' => 'https://pub-628304d7b25d454abf303bfafba6a2e0.r2.dev/ALADDINN/gamelogo/JDB/14006.png',
        'imgUrl2' => '',
        'winOdds' => 80.48
    ],
    [
        'vendorId' => '2',
        'gameCode' => '08ced9dd788aed11ff3c7f387ae0f063',
        'gameNameEn' => 'Paradise',
        'imgUrl' => 'https://pub-628304d7b25d454abf303bfafba6a2e0.r2.dev/ALADDINN/gamelogo/CQ9/AB3.png',
        'imgUrl2' => '',
        'winOdds' => 90.36
    ],
    [
        'vendorId' => '2',
        'gameCode' => 'fb33a6613e5ba5b8e42f035fbd4e103d',
        'gameNameEn' => 'Zeus M',
        'imgUrl' => 'https://pub-628304d7b25d454abf303bfafba6a2e0.r2.dev/ALADDINN/gamelogo/CQ9/125.png',
        'imgUrl2' => '',
        'winOdds' => 89.18
    ],
   
];
$data['popular']['clicksVideoTopList'] = [
    [
        'vendorId' => '16',
        'gameCode' => '9f4xhuhdd005xlbl',
        'gameNameEn' => 'Blackjack Silver B',
        'imgUrl' => 'https://pub-628304d7b25d454abf303bfafba6a2e0.r2.dev/ALADDINN/gamelogo/EVO_Video/9f4xhuhdd005xlbl.png',
        'imgUrl2' => '',
        'winOdds' => 0.0
    ],
    [
        'vendorId' => '16',
        'gameCode' => 'AmericanTable001',
        'gameNameEn' => 'American Roulette',
        'imgUrl' => 'https://pub-628304d7b25d454abf303bfafba6a2e0.r2.dev/ALADDINN/gamelogo/EVO_Video/AmericanTable001.png',
        'imgUrl2' => '',
        'winOdds' => 0.0
    ],
    [
        'vendorId' => '16',
        'gameCode' => 'AndarBahar000001',
        'gameNameEn' => 'Super Andar Bahar',
        'imgUrl' => 'https://pub-628304d7b25d454abf303bfafba6a2e0.r2.dev/ALADDINN/gamelogo/EVO_Video/AndarBahar000001.png',
        'imgUrl2' => '',
        'winOdds' => 0.0
    ],
    [
        'vendorId' => '16',
        'gameCode' => 'BacBo00000000001',
        'gameNameEn' => 'Bac Bo',
        'imgUrl' => 'https://pub-628304d7b25d454abf303bfafba6a2e0.r2.dev/ALADDINN/gamelogo/EVO_Video/BacBo00000000001.png',
        'imgUrl2' => '',
        'winOdds' => 0.0
    ],
    [
        'vendorId' => '16',
        'gameCode' => 'bciewncrf5ijneys',
        'gameNameEn' => 'Blackjack VIP U',
        'imgUrl' => 'https://pub-628304d7b25d454abf303bfafba6a2e0.r2.dev/ALADDINN/gamelogo/EVO_Video/bciewncrf5ijneys.png',
        'imgUrl2' => '',
        'winOdds' => 0.0
    ],
    [
        'vendorId' => '16',
        'gameCode' => 'bghflgi59db7d7r2',
        'gameNameEn' => 'Blackjack VIP X',
        'imgUrl' => 'https://pub-628304d7b25d454abf303bfafba6a2e0.r2.dev/ALADDINN/gamelogo/EVO_Video/bghflgi59db7d7r2.png',
        'imgUrl2' => '',
        'winOdds' => 0.0
    ],
    [
        'vendorId' => '16',
        'gameCode' => 'BonsaiBacc000001',
        'gameNameEn' => 'Bonsai Speed Baccarat A',
        'imgUrl' => 'https://pub-628304d7b25d454abf303bfafba6a2e0.r2.dev/ALADDINN/gamelogo/EVO_Video/BonsaiBacc000001.png',
        'imgUrl2' => '',
        'winOdds' => 0.0
    ],
    [
        'vendorId' => '16',
        'gameCode' => 'BonsaiBacc000002',
        'gameNameEn' => 'Bonsai Speed Baccarat B',
        'imgUrl' => 'https://pub-628304d7b25d454abf303bfafba6a2e0.r2.dev/ALADDINN/gamelogo/EVO_Video/BonsaiBacc000002.png',
        'imgUrl2' => '',
        'winOdds' => 0.0
    ],
    [
        'vendorId' => '16',
        'gameCode' => 'BonsaiBacc000003',
        'gameNameEn' => 'Bonsai Speed Baccarat C',
        'imgUrl' => 'https://pub-628304d7b25d454abf303bfafba6a2e0.r2.dev/ALADDINN/gamelogo/EVO_Video/BonsaiBacc000003.png',
        'imgUrl2' => '',
        'winOdds' => 0.0
    ]
];
$data['sport'] = [
    [
        "slotsTypeID" => 25,
        "slotsName" => "Wickets9",
        "state" => 1,
        "vendorImg" => "https://pub-628304d7b25d454abf303bfafba6a2e0.r2.dev/ALADDINN/vendorlogo/vendorlogo_20240411190844d133.png"
    ],
    [
        "slotsTypeID" => 14,
        "slotsName" => "SaBa",
        "state" => 1,
        "vendorImg" => "https://pub-628304d7b25d454abf303bfafba6a2e0.r2.dev/ALADDINN/vendorlogo/vendorlogo_20240411191851up8s.png"
    ]
];

$data['lottery'] = [
    [
        "id" => 1,
        "categoryCode" => "Win Go",
        "categoryName" => "WinGo彩票",
        "state" => 1,
        "sort" => 0,
        "categoryImg" => "https://pub-628304d7b25d454abf303bfafba6a2e0.r2.dev/ALADDINN/lotterycategory/lotterycategory_20240321194458iceq.png",
        "wingoAmount" => null,
        "k3Amount" => null,
        "fiveDAmount" => null,
        "trxWingoAmount" => null
    ],
    [
        "id" => 2,
        "categoryCode" => "K3",
        "categoryName" => "K3彩票",
        "state" => 1,
        "sort" => 0,
        "categoryImg" => "https://pub-628304d7b25d454abf303bfafba6a2e0.r2.dev/ALADDINN/lotterycategory/lotterycategory_20240321194451en5o.png",
        "wingoAmount" => null,
        "k3Amount" => null,
        "fiveDAmount" => null,
        "trxWingoAmount" => null
    ],
    [
        "id" => 3,
        "categoryCode" => "5D",
        "categoryName" => "5D彩票",
        "state" => 1,
        "sort" => 0,
        "categoryImg" => "https://pub-628304d7b25d454abf303bfafba6a2e0.r2.dev/ALADDINN/lotterycategory/lotterycategory_20240321194510h9i1.png",
        "wingoAmount" => null,
        "k3Amount" => null,
        "fiveDAmount" => null,
        "trxWingoAmount" => null
    ]
];

$data['awardRecordList'] = [
    [
        "orderId" => 3680463,
        "userId" => 2796393,
        "userPhoto" => "1",
        "userName" => "917828775413",
        "gameName" => "Mines",
        "imgUrl" => "https://pub-628304d7b25d454abf303bfafba6a2e0.r2.dev/ALADDINN/gamelogo/TB_Chess/100.png",
        "imgUrl2" => "",
        "multiple" => 18.59,
        "bonusAmount" => 20.00,
        "multipleName" => "10-19.99",
        "createTime" => "2024-11-06 10:42:00"
    ],
    [
        "orderId" => 3680462,
        "userId" => 3868126,
        "userPhoto" => "1",
        "userName" => "919565594888",
        "gameName" => "Fortune Gems",
        "imgUrl" => "https://pub-628304d7b25d454abf303bfafba6a2e0.r2.dev/ALADDINN/gamelogo/JILI/109.png",
        "imgUrl2" => "",
        "multiple" => 26.67,
        "bonusAmount" => 50.00,
        "multipleName" => "20-29.99",
        "createTime" => "2024-11-06 10:42:00"
    ],
    [
        "orderId" => 3680461,
        "userId" => 4067380,
        "userPhoto" => "1",
        "userName" => "918971120563",
        "gameName" => "Fortune Gems 2",
        "imgUrl" => "https://pub-628304d7b25d454abf303bfafba6a2e0.r2.dev/ALADDINN/gamelogo/JILI/223.png",
        "imgUrl2" => "",
        "multiple" => 10.00,
        "bonusAmount" => 20.00,
        "multipleName" => "10-19.99",
        "createTime" => "2024-11-06 10:42:00"
    ],
    [
        "orderId" => 3680460,
        "userId" => 3868126,
        "userPhoto" => "1",
        "userName" => "919565594888",
        "gameName" => "Fortune Gems",
        "imgUrl" => "https://pub-628304d7b25d454abf303bfafba6a2e0.r2.dev/ALADDINN/gamelogo/JILI/109.png",
        "imgUrl2" => "",
        "multiple" => 26.67,
        "bonusAmount" => 50.00,
        "multipleName" => "20-29.99",
        "createTime" => "2024-11-06 10:42:00"
    ],
    [
        "orderId" => 3680459,
        "userId" => 3117774,
        "userPhoto" => "1",
        "userName" => "918003821973",
        "gameName" => "Fortune Gems 2",
        "imgUrl" => "https://pub-628304d7b25d454abf303bfafba6a2e0.r2.dev/ALADDINN/gamelogo/JILI/223.png",
        "imgUrl2" => "",
        "multiple" => 30.00,
        "bonusAmount" => 100.00,
        "multipleName" => "30-39.99",
        "createTime" => "2024-11-06 10:42:00"
    ]
];
$data['slot'] = [
    [
        "slotsTypeID" => 2,
        "slotsName" => "CQ9",
        "state" => 1,
        "vendorImg" => "https://pub-628304d7b25d454abf303bfafba6a2e0.r2.dev/ALADDINN/lotterycategory/vendorlogo_20240401192314s38c.png"
    ],
    [
        "slotsTypeID" => 6,
        "slotsName" => "JDB",
        "state" => 1,
        "vendorImg" => "https://pub-628304d7b25d454abf303bfafba6a2e0.r2.dev/ALADDINN/lotterycategory/vendorlogo_20240401192353o642.png"
    ],
    
    [
        "slotsTypeID" => 18,
        "slotsName" => "JILI",
        "state" => 1,
        "vendorImg" => "https://pub-628304d7b25d454abf303bfafba6a2e0.r2.dev/ALADDINN/lotterycategory/vendorlogo_20240401192201ifjd.png"
    ],
    [
        "slotsTypeID" => 17,
        "slotsName" => "PG",
        "state" => 1,
        "vendorImg" => "https://ik.imagekit.io/oalh9ykvvgo/PG-SLOTS__ZVCGCyDbZ.png"
    ],
  
    [
        "slotsTypeID" => 9,
        "slotsName" => "KM",
        "state" => 1,
        "vendorImg" => "https://ik.imagekit.io/oalh9ykvvgo/KM-Slots_qLvfsXWHaI.png?updatedAt=1737439318243"
    ],
    [
        "slotsTypeID" => 101,
        "slotsName" => "IDG",
        "state" => 1,
        "vendorImg" => "https://ik.imagekit.io/oalh9ykvvgo/ideal-slots_BFoKdb-L5.png?updatedAt=1737439956660"
    ]
];
$data['video'] = [
    [
        "slotsTypeID" => 7,
        "slotsName" => "DG",
        "state" => 1,
        'gameCode' => '3630a6a3c836afa6864578ef21f8fa93',
        "vendorImg" => "https://pub-628304d7b25d454abf303bfafba6a2e0.r2.dev/ALADDINN/vendorlogo/vendorlogo_20240814164556aebw.png"
    ],
    [
        "slotsTypeID" => 16,
        "slotsName" => "EVO_Video",
        "state" => 1,
        'gameCode' => '837c69cad673580542f91974993b7bff',
        "vendorImg" => "https://pub-628304d7b25d454abf303bfafba6a2e0.r2.dev/ALADDINN/vendorlogo/vendorlogo_202408141645094l9r.png"
    ],
    [
        "slotsTypeID" => 10,
        "slotsName" => "AG_Video",
        'gameCode' => '3630a6a3c836afa6864578ef21f8fa93',
        "state" => 1,
        "vendorImg" => "https://pub-628304d7b25d454abf303bfafba6a2e0.r2.dev/ALADDINN/vendorlogo/vendorlogo_20240814164454cjxs.png"
    ],
    [
        "slotsTypeID" => 26,
        "slotsName" => "WM_Video",
        'gameCode' => '3630a6a3c836afa6864578ef21f8fa93',
        "state" => 1,
        "vendorImg" => "https://pub-628304d7b25d454abf303bfafba6a2e0.r2.dev/ALADDINN/vendorlogo/vendorlogo_20240814164525my3f.png"
    ],
    [
        "slotsTypeID" => 27,
        "slotsName" => "SEXY_Video",
        'gameCode' => '3630a6a3c836afa6864578ef21f8fa93',
        "state" => 1,
        "vendorImg" => "https://pub-628304d7b25d454abf303bfafba6a2e0.r2.dev/ALADDINN/vendorlogo/vendorlogo_20240814164544e2mx.png"
    ]
];
$data['fish'] = [
    [
        "gameID" => "e794bf5717aca371152df192341fe68b",
        "gameNameEn" => "Royal Fishing",
        "img" => "https://pub-628304d7b25d454abf303bfafba6a2e0.r2.dev/ALADDINN/gamelogo/JILI/1.png",
        "vendorId" => 18,
        "imgUrl2" => "",
        "customGameType" => 0
    ],
    [
        "gameID" => "9ec2a18752f83e45ccedde8dfeb0f6a7",
        "gameNameEn" => "All-star Fishing",
        "img" => "https://pub-628304d7b25d454abf303bfafba6a2e0.r2.dev/ALADDINN/gamelogo/JILI/119.png",
        "vendorId" => 18,
        "imgUrl2" => "",
        "customGameType" => 0
    ],
    [
        "gameID" => "e333695bcff28acdbecc641ae6ee2b23",
        "gameNameEn" => "Bombing Fishing",
        "img" => "https://pub-628304d7b25d454abf303bfafba6a2e0.r2.dev/ALADDINN/gamelogo/JILI/20.png",
        "vendorId" => 18,
        "imgUrl2" => "",
        "customGameType" => 0
    ],
    [
        "gameID" => "bbae6016f79f3df74e453eda164c08a4",
        "gameNameEn" => "Dinosaur Tycoon II",
        "img" => "https://pub-628304d7b25d454abf303bfafba6a2e0.r2.dev/ALADDINN/gamelogo/JILI/212.png",
        "vendorId" => 18,
        "imgUrl2" => "",
        "customGameType" => 0
    ],
    [
        "gameID" => "3cf4a85cb6dcf4d8836c982c359cd72d",
        "gameNameEn" => "Jack Pot Fishing",
        "img" => "https://pub-628304d7b25d454abf303bfafba6a2e0.r2.dev/ALADDINN/gamelogo/JILI/32.png",
        "vendorId" => 18,
        "imgUrl2" => "",
        "customGameType" => 0
    ],
    [
        "gameID" => "eef3e28f0e3e7b72cbca61e7924d00f1",
        "gameNameEn" => "Dinosaur Tycoon",
        "img" => "https://pub-628304d7b25d454abf303bfafba6a2e0.r2.dev/ALADDINN/gamelogo/JILI/42.png",
        "vendorId" => 18,
        "imgUrl2" => "",
        "customGameType" => 0
    ],
    [
        "gameID" => "1200b82493e4788d038849bca884d773",
        "gameNameEn" => "Dragon Fortune",
        "img" => "https://pub-628304d7b25d454abf303bfafba6a2e0.r2.dev/ALADDINN/gamelogo/JILI/60.png",
        "vendorId" => 18,
        "imgUrl2" => "",
        "customGameType" => 0
    ],
    [
        "gameID" => "f02ede19c5953fce22c6098d860dadf4",
        "gameNameEn" => "Boom Legend",
        "img" => "https://pub-628304d7b25d454abf303bfafba6a2e0.r2.dev/ALADDINN/gamelogo/JILI/71.png",
        "vendorId" => 18,
        "imgUrl2" => "",
        "customGameType" => 0
    ],
    [
        "gameID" => "caacafe3f64a6279e10a378ede09ff38",
        "gameNameEn" => "Mega Fishing",
        "img" => "https://pub-628304d7b25d454abf303bfafba6a2e0.r2.dev/ALADDINN/gamelogo/JILI/74.png",
        "vendorId" => 18,
        "imgUrl2" => "",
        "customGameType" => 0
    ],
    [
        "gameID" => "71c68a4ddb63bdc8488114a08e603f1c",
        "gameNameEn" => "Happy Fishing",
        "img" => "https://pub-628304d7b25d454abf303bfafba6a2e0.r2.dev/ALADDINN/gamelogo/JILI/82.png",
        "vendorId" => 18,
        "imgUrl2" => "",
        "customGameType" => 0
    ]
];
$data['flash'] = [
    [
        "gameID" => "a9a6f0dab1c2cd8c11b395d230e273ce",
        "gameNameEn" => "Aviator",
        "img" => "https://pub-628304d7b25d454abf303bfafba6a2e0.r2.dev/ALADDINN/gamelogo/SPRIBE/22001.png",
        "vendorId" => 20,
        "imgUrl2" => "",
        "customGameType" => 0
    ],
    [
        "gameID" => "8a87aae7a3624d284306e9c6fe1b3e9c",
        "gameNameEn" => "Dice",
        "img" => "https://pub-628304d7b25d454abf303bfafba6a2e0.r2.dev/ALADDINN/gamelogo/SPRIBE/22002.png",
        "vendorId" => 20,
        "imgUrl2" => "",
        "customGameType" => 0
    ],
    [
        "gameID" => "c68a515f0b3b10eec96cf6d33299f4e2",
        "gameNameEn" => "Goal",
        "img" => "https://pub-628304d7b25d454abf303bfafba6a2e0.r2.dev/ALADDINN/gamelogo/SPRIBE/22003.png",
        "vendorId" => 20,
        "imgUrl2" => "",
        "customGameType" => 0
    ],
    [
        "gameID" => "6ab7a4fe5161936012d6b06143918223",
        "gameNameEn" => "Plinko",
        "img" => "https://pub-628304d7b25d454abf303bfafba6a2e0.r2.dev/ALADDINN/gamelogo/SPRIBE/22004.png",
        "vendorId" => 20,
        "imgUrl2" => "",
        "customGameType" => 0
    ],
    [
        "gameID" => "5c4a12fb0a9b296d9b0d5f9e1cd41d65",
        "gameNameEn" => "Mines",
        "img" => "https://pub-628304d7b25d454abf303bfafba6a2e0.r2.dev/ALADDINN/gamelogo/SPRIBE/22005.png",
        "vendorId" => 20,
        "imgUrl2" => "",
        "customGameType" => 0
    ],
    [
        "gameID" => "a669c993b0e1f1b7da100fcf95516bdf",
        "gameNameEn" => "Hilo",
        "img" => "https://pub-628304d7b25d454abf303bfafba6a2e0.r2.dev/ALADDINN/gamelogo/SPRIBE/22006.png",
        "vendorId" => 20,
        "imgUrl2" => "",
        "customGameType" => 0
    ],
    [
        "gameID" => "c311eb4bbba03b105d150504931f2479",
        "gameNameEn" => "Keno",
        "img" => "https://pub-628304d7b25d454abf303bfafba6a2e0.r2.dev/ALADDINN/gamelogo/SPRIBE/22007.png",
        "vendorId" => 20,
        "imgUrl2" => "",
        "customGameType" => 0
    ],
    [
        "gameID" => "9dc7ac6155c5a19c1cc204853e426367",
        "gameNameEn" => "Mini Roulette",
        "img" => "https://pub-628304d7b25d454abf303bfafba6a2e0.r2.dev/ALADDINN/gamelogo/SPRIBE/22008.png",
        "vendorId" => 20,
        "imgUrl2" => "",
        "customGameType" => 0
    ]
];
$data['lottery'] = [
    [
        "id" => 1,
        "categoryCode" => "Win Go",
        "categoryName" => "WinGo彩票",
        "state" => 1,
        "sort" => 0,
        "categoryImg" => "https://pub-628304d7b25d454abf303bfafba6a2e0.r2.dev/ALADDINN/lotterycategory/lotterycategory_20240321194458iceq.png",
        "wingoAmount" => null,
        "k3Amount" => null,
        "fiveDAmount" => null,
        "trxWingoAmount" => null
    ],
    [
        "id" => 2,
        "categoryCode" => "K3",
        "categoryName" => "K3彩票",
        "state" => 1,
        "sort" => 0,
        "categoryImg" => "https://pub-628304d7b25d454abf303bfafba6a2e0.r2.dev/ALADDINN/lotterycategory/lotterycategory_20240321194451en5o.png",
        "wingoAmount" => null,
        "k3Amount" => null,
        "fiveDAmount" => null,
        "trxWingoAmount" => null
    ],
    [
        "id" => 3,
        "categoryCode" => "5D",
        "categoryName" => "5D彩票",
        "state" => 1,
        "sort" => 0,
        "categoryImg" => "https://pub-628304d7b25d454abf303bfafba6a2e0.r2.dev/ALADDINN/lotterycategory/lotterycategory_20240321194510h9i1.png",
        "wingoAmount" => null,
        "k3Amount" => null,
        "fiveDAmount" => null,
        "trxWingoAmount" => null
    ],
  [
        "id" => 4,
        "categoryCode" => "Trx Win Go",
        "categoryName" => "TrxWinGo彩票",
        "state" => 1,
        "sort" => 0,
        "categoryImg" => "https://ossimg.Big-Mumadmin888.com/bigmumbai/lotterycategory/lotterycategory_20230724173608dkuw.png",
        "wingoAmount" => null,
        "k3Amount" => null,
        "fiveDAmount" => null,
        "trxWingoAmount" => null
    ],
];
$data['awardRecordList'] = [
    [
        "orderId" => 3686187,
        "userId" => 5177592,
        "userPhoto" => "6",
        "userName" => "918354063640",
        "gameName" => "Crazy777",
        "imgUrl" => "https://pub-628304d7b25d454abf303bfafba6a2e0.r2.dev/ALADDINN/gamelogo/JILI/35.png",
        "imgUrl2" => "",
        "multiple" => 66.67,
        "bonusAmount" => 250.00,
        "multipleName" => "60-99999",
        "createTime" => "2024-11-06 14:39:02"
    ],
    [
        "orderId" => 3686186,
        "userId" => 535736,
        "userPhoto" => "1",
        "userName" => "959929202173",
        "gameName" => "Money Coming",
        "imgUrl" => "https://pub-628304d7b25d454abf303bfafba6a2e0.r2.dev/ALADDINN/gamelogo/JILI/51.png",
        "imgUrl2" => "",
        "multiple" => 20.00,
        "bonusAmount" => 100.00,
        "multipleName" => "20-29.99",
        "createTime" => "2024-11-06 14:39:02"
    ],
    [
        "orderId" => 3686185,
        "userId" => 6163018,
        "userPhoto" => "1",
        "userName" => "919166143942",
        "gameName" => "Wheel",
        "imgUrl" => "https://pub-628304d7b25d454abf303bfafba6a2e0.r2.dev/ALADDINN/gamelogo/JILI/236.png",
        "imgUrl2" => "",
        "multiple" => 14.00,
        "bonusAmount" => 20.00,
        "multipleName" => "10-19.99",
        "createTime" => "2024-11-06 14:39:02"
    ],
    [
        "orderId" => 3686184,
        "userId" => 6721420,
        "userPhoto" => "1",
        "userName" => "919510027410",
        "gameName" => "Fortune Gems 2",
        "imgUrl" => "https://pub-628304d7b25d454abf303bfafba6a2e0.r2.dev/ALADDINN/gamelogo/JILI/223.png",
        "imgUrl2" => "",
        "multiple" => 20.00,
        "bonusAmount" => 50.00,
        "multipleName" => "20-29.99",
        "createTime" => "2024-11-06 14:39:02"
    ],
    [
        "orderId" => 3686183,
        "userId" => 6065144,
        "userPhoto" => "20",
        "userName" => "916261265979",
        "gameName" => "Money Coming",
        "imgUrl" => "https://pub-628304d7b25d454abf303bfafba6a2e0.r2.dev/ALADDINN/gamelogo/JILI/51.png",
        "imgUrl2" => "",
        "multiple" => 20.00,
        "bonusAmount" => 50.00,
        "multipleName" => "20-29.99",
        "createTime" => "2024-11-06 14:39:02"
    ],
    [
        "orderId" => 3686182,
        "userId" => 3326510,
        "userPhoto" => "5",
        "userName" => "919521542981",
        "gameName" => "Money Coming",
        "imgUrl" => "https://pub-628304d7b25d454abf303bfafba6a2e0.r2.dev/ALADDINN/gamelogo/JILI/51.png",
        "imgUrl2" => "",
        "multiple" => 25.00,
        "bonusAmount" => 50.00,
        "multipleName" => "20-29.99",
        "createTime" => "2024-11-06 14:39:02"
    ],
    [
        "orderId" => 3686181,
        "userId" => 6166646,
        "userPhoto" => "4",
        "userName" => "918181815448",
        "gameName" => "Fortune Gems 2",
        "imgUrl" => "https://pub-628304d7b25d454abf303bfafba6a2e0.r2.dev/ALADDINN/gamelogo/JILI/223.png",
        "imgUrl2" => "",
        "multiple" => 10.67,
        "bonusAmount" => 20.00,
        "multipleName" => "10-19.99",
        "createTime" => "2024-11-06 14:39:02"
    ],
    [
        "orderId" => 3686180,
        "userId" => 6607199,
        "userPhoto" => "1",
        "userName" => "9106000020581",
        "gameName" => "Money Coming",
        "imgUrl" => "https://pub-628304d7b25d454abf303bfafba6a2e0.r2.dev/ALADDINN/gamelogo/JILI/51.png",
        "imgUrl2" => "",
        "multiple" => 10.00,
        "bonusAmount" => 50.00,
        "multipleName" => "10-19.99",
        "createTime" => "2024-11-06 14:39:02"
    ],
    [
        "orderId" => 3686179,
        "userId" => 1119113,
        "userPhoto" => "1",
        "userName" => "916264954165",
        "gameName" => "Boxing King",
        "imgUrl" => "https://pub-628304d7b25d454abf303bfafba6a2e0.r2.dev/ALADDINN/gamelogo/JILI/77.png",
        "imgUrl2" => "",
        "multiple" => 10.80,
        "bonusAmount" => 50.00,
        "multipleName" => "10-19.99",
        "createTime" => "2024-11-06 14:39:02"
    ],
    [
        "orderId" => 3686178,
        "userId" => 6065144,
        "userPhoto" => "20",
        "userName" => "916261265979",
        "gameName" => "Money Coming",
        "imgUrl" => "https://pub-628304d7b25d454abf303bfafba6a2e0.r2.dev/ALADDINN/gamelogo/JILI/51.png",
        "imgUrl2" => "",
        "multiple" => 10.00,
        "bonusAmount" => 50.00,
        "multipleName" => "10-19.99",
        "createTime" => "2024-11-06 14:39:02"
    ]
];
$data['chess'] = [
    [
        "slotsTypeID" => 21,
        "slotsName" => "V8Card",
        "state" => 1,
        "vendorImg" => "https://pub-628304d7b25d454abf303bfafba6a2e0.r2.dev/ALADDINN/vendorlogo/vendorlogo_20240814164325mywo.png"
    ]
];
		
			
				$res['data'] = $data;
				$res['code'] = 0;
				$res['msg'] = 'Succeed';
				$res['msgCode'] = 0;
				http_response_code(200);
				echo json_encode($res);
			}
			else{
				$res['code'] = 5;
				$res['msg'] = 'Wrong signature';
				$res['msgCode'] = 3;
				http_response_code(200);
				echo json_encode($res);
			}
		}
		else{
			$res['code'] = 7;
			$res['msg'] = 'Param is Invalid';
			$res['msgCode'] = 6;
			http_response_code(200);
			echo json_encode($res);
		}		
	} else {		
		http_response_code(405);
		echo json_encode($res);
	}
?>