<?php
include "../../conn.php";
include "../../functions2.php";

header('Content-Type: application/json; charset=utf-8');
header('Strict-Transport-Security: max-age=31536000');
header('Access-Control-Allow-Headers: Origin, X-Requested-With, Content-Type, Accept, Authorization');
header('Access-Control-Allow-Credentials: true');
$origin = isset($_SERVER['HTTP_ORIGIN']) ? $_SERVER['HTTP_ORIGIN'] : '';
header('Access-Control-Allow-Origin: ' . $origin);
header('vary: Origin');

date_default_timezone_set("Asia/Kolkata");
$shnunc = date("Y-m-d H:i:s");
$res = [
    'code' => 11,
    'msg' => 'Method not allowed',
    'msgCode' => 12,
    'serviceNowTime' => $shnunc,
];
$shonubody = file_get_contents("php://input");
$shonupost = json_decode($shonubody, true);

if ($_SERVER['REQUEST_METHOD'] != 'GET') {
    if (isset($shonupost['language']) && isset($shonupost['random']) && isset($shonupost['signature']) && isset($shonupost['timestamp'])) {
        $language = htmlspecialchars(mysqli_real_escape_string($conn, $shonupost['language']));
        $random = htmlspecialchars(mysqli_real_escape_string($conn, $shonupost['random']));
        $signature = htmlspecialchars(mysqli_real_escape_string($conn, $shonupost['signature']));
        $shonustr = '{"language":' . $language . ',"random":"' . $random . '"}';
        $shonusign = strtoupper(md5($shonustr));
        if ($shonusign == $signature) {
            $bearer = explode(" ", $_SERVER['HTTP_AUTHORIZATION']);
            $author = $bearer[1];
            $is_jwt_valid = is_jwt_valid($author);
            $data_auth = json_decode($is_jwt_valid, 1);
            if ($data_auth['status'] === 'Success') {
                $sesquery = "SELECT akshinak
					  FROM shonu_subjects
					  WHERE akshinak = '$author'";
                $sesresult = $conn->query($sesquery);
                $sesnum = mysqli_num_rows($sesresult);
                if ($sesnum == 1) {
                    $balquery = "SELECT motta
						  FROM shonu_kaichila
						  WHERE balakedara = " . $data_auth['payload']['id'];
                    $balresult = $conn->query($balquery);
                    $balarr = mysqli_fetch_array($balresult);
                    $data['thidGameBalanceList'][0]['vendorCode'] = 'Lottery';
                    $data['thidGameBalanceList'][0]['balance'] = (int)$balarr['motta'];
                    $data['thidGameBalanceList'][1]['vendorCode'] = 'TB_Chess';
                    $data['thidGameBalanceList'][1]['balance'] = 0;
                    $data['thidGameBalanceList'][2]['vendorCode'] = 'Wickets9';
                    $data['thidGameBalanceList'][2]['balance'] = 0;
                    $data['thidGameBalanceList'][3]['vendorCode'] = 'CQ9';
                    $data['thidGameBalanceList'][3]['balance'] = 0;
                    $data['thidGameBalanceList'][4]['vendorCode'] = 'MG';
                    $data['thidGameBalanceList'][4]['balance'] = 0;
                    $data['thidGameBalanceList'][5]['vendorCode'] = 'JDB';
                    $data['thidGameBalanceList'][5]['balance'] = 0;
                    $data['thidGameBalanceList'][6]['vendorCode'] = 'DG';
                    $data['thidGameBalanceList'][6]['balance'] = 0;
                    $data['thidGameBalanceList'][7]['vendorCode'] = 'CMD';
                    $data['thidGameBalanceList'][7]['balance'] = 0;
                    $data['thidGameBalanceList'][8]['vendorCode'] = 'SaBa';
                    $data['thidGameBalanceList'][8]['balance'] = 0;
                    $data['thidGameBalanceList'][9]['vendorCode'] = 'EVO_Video';
                    $data['thidGameBalanceList'][9]['balance'] = 0;
                    $data['thidGameBalanceList'][10]['vendorCode'] = 'JILI';
                    $data['thidGameBalanceList'][10]['balance'] = 0;
                    $data['thidGameBalanceList'][11]['vendorCode'] = 'Card365';
                    $data['thidGameBalanceList'][11]['balance'] = 0;
                    $data['thidGameBalanceList'][12]['vendorCode'] = 'V8Card';
                    $data['thidGameBalanceList'][12]['balance'] = 0;
                    $data['thidGameBalanceList'][13]['vendorCode'] = 'AG_Video';
                    $data['thidGameBalanceList'][13]['balance'] = 0;
                    $data['thidGameBalanceList'][14]['vendorCode'] = 'PG';
                    $data['thidGameBalanceList'][14]['balance'] = 0;
                    $data['thidGameBalanceList'][15]['vendorCode'] = 'TB';
                    $data['thidGameBalanceList'][15]['balance'] = 0;
                    $data['thidGameBalanceList'][16]['vendorCode'] = 'WM_Video';
                    $data['thidGameBalanceList'][16]['balance'] = 0;
                    $data['thidGameBalanceList'][16]['vendorCode'] = 'SEXY_Video';
                    $data['thidGameBalanceList'][16]['balance'] = 0;



                    // Fetch user details from the database using the token
                    $userQuery = "SELECT id FROM shonu_subjects WHERE akshinak = '$author'";
                    $userResult = $conn->query($userQuery);

                    // Encrypt payload using AES256 (ECB mode)
                    function encryptAES256ECB($data, $key)
                    {
                        // Ensure the key length is 32 bytes (AES-256 requires 256-bit keys, i.e., 32 bytes)
                        $key = str_pad($key, 32, "\0"); // Pad key if it is less than 32 bytes

                        $encryptedData = openssl_encrypt($data, 'AES-256-ECB', $key, OPENSSL_RAW_DATA);
                        return base64_encode($encryptedData); // Return base64-encoded encrypted data
                    }

                    if ($userResult && $userResult->num_rows > 0) {
                        $userRow = $userResult->fetch_assoc();
                        $userName = $userRow['id']; // 'id' corresponds to 'userName'

                        // Fetch user balance from shonu_kaichila using the userName
                        $balanceQuery = "SELECT motta FROM shonu_kaichila WHERE balakedara = '$userName'";
                        $balanceResult = $conn->query($balanceQuery);

                        if ($balanceResult && $balanceResult->num_rows > 0) {
                            $balanceRow = $balanceResult->fetch_assoc();
                            $userBalance = $balanceRow['motta']; // 'motta' is the balance column

                            // Initialize payload for external API call to get the after_amount
                            $timestamp = round(microtime(true) * 1000); // Milliseconds timestamp
                            $memberAccount = "h7bfd4{$userName}newAladdinn Gamebdg"; // Generate member account dynamically
                            $transferId = $memberAccount . '_' . bin2hex(random_bytes(3)); // Unique transfer ID
                            $aesKey = "b2a5ec5d13dd4248b330551d585440ba"; // AES Key for encryption
                            $serverUrl = "https://jsgame.live/game/v2"; // API URL

                            // Step 1: Initialize the payload with a balance of 0
                            $initPayload = [
                                'agency_uid' => "6670d2d096b3285fa8daa930c3cf2a1b",
                                'member_account' => $memberAccount,
                                'timestamp' => $timestamp,
                                'credit_amount' => "0", // Set balance to 0
                                'currency_code' => "BRL",
                                'language' => "en",
                                'platform' => "2",
                                'home_url' => $origin, // Using the origin header as referer
                                'transfer_id' => $transferId,
                            ];

                            // Encrypt the payload using AES256 (ECB mode)
                            $initEncryptedPayload = encryptAES256ECB(json_encode($initPayload), $aesKey);

                            // Step 2: Prepare the request payload for the initial API request
                            $initRequestPayload = [
                                'agency_uid' => "6670d2d096b3285fa8daa930c3cf2a1b",
                                'timestamp' => $timestamp,
                                'payload' => $initEncryptedPayload,
                            ];

                            // Send the initial request to the server (for balance deduction initialization)
                            $ch = curl_init($serverUrl);
                            curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
                            curl_setopt($ch, CURLOPT_POST, true);
                            curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($initRequestPayload));
                            curl_setopt($ch, CURLOPT_HTTPHEADER, ['Content-Type: application/json']);
                            $initResponse = curl_exec($ch);
                            $httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
                            curl_close($ch);

                            // Handle the initial response
                            if ($httpCode === 200 && $initResponse !== false) {
                                $initResponseData = json_decode($initResponse, true);

                                // Check if the response is successful and get the after_amount
                                if ($initResponseData['code'] === 0) {
                                    $initAdd = $initResponseData['payload']['after_amount']; // Amount to deduct

                                    // Replace the hardcoded balance for Js Game with the fetched balance from the API
                                    $data['thidGameBalanceList'][17]['vendorCode'] = 'Js Game';
                                    $data['thidGameBalanceList'][17]['balance'] = (int)$initAdd; // Set balance to after_amount
                                } else {
                                    // Handle error during the API call
                                    $res['code'] = $initResponseData['code'];
                                    $res['msg'] = 'Error fetching balance for Js Game: ' . $initResponseData['msg'];
                                    http_response_code(400);
                                    echo json_encode($res);
                                    exit;
                                }
                            } else {
                                // Handle failure to fetch data from the server
                                $res['code'] = 9;
                                $res['msg'] = 'Failed to connect to the API server for balance info';
                                $res['error'] = 'Error in initialization API request';
                                http_response_code(500);
                                echo json_encode($res);
                                exit;
                            }
                        }
                    }





                    $data['totalWithdraw'] = 0;
                    $data['totalRecharge'] = 0;

                    $res['data'] = $data;
                    $res['code'] = 0;
                    $res['msg'] = 'Succeed';
                    $res['msgCode'] = 0;
                    http_response_code(200);
                    echo json_encode($res);
                } else {
                    $res['code'] = 4;
                    $res['msg'] = 'No operation permission';
                    $res['msgCode'] = 2;
                    http_response_code(401);
                    echo json_encode($res);
                }
            } else {
                $res['code'] = 4;
                $res['msg'] = 'No operation permission';
                $res['msgCode'] = 2;
                http_response_code(401);
                echo json_encode($res);
            }
        } else {
            $res['code'] = 5;
            $res['msg'] = 'Wrong signature';
            $res['msgCode'] = 3;
            http_response_code(200);
            echo json_encode($res);
        }
    } else {
        $res['code'] = 7;
        $res['msg'] = 'Param is Invalid';
        $res['msgCode'] = 6;
        http_response_code(200);
        echo json_encode($res);
    }
} else {
    http_response_code(405);
    echo json_encode($res);
}
