<?php
header("Access-Control-Allow-Origin: http://diuvin.shop");
header("Access-Control-Allow-Methods: GET, POST, PUT, DELETE, OPTIONS");
header("Access-Control-Allow-Headers: Content-Type, Access-Control-Allow-Headers, Authorization, X-Requested-With");
$postData = file_get_contents("php://input");

$data = json_decode($postData, true);

if (!isset($data['payid'])) {
    exit(json_encode([
        "code" => 1,
        "msg" => "payID not found in payload"
    ]));
}

$payID = $data['payid'];

$responseData = [];

if ($payID == 2) {
    $responseData = [
        "rechargetypelist" => [
            [
                "payTypeID" => 1023,
                "payID" => 2,
                "payName" => "IndianPay",
                "paySysName" => "923",
                "miniPrice" => 200.00,
                "maxPrice" => 50000.00,
                "scope" => "100|300|500|1000|5000|10000",
                "paySendUrl" => "https://pocowin.com/pay/jerrylawler",
                "parameters" => "",
                "startTime" => "00:00",
                "endTime" => "24:00",
                "rechargeRifts" => 0.0000,
                "c2cUnitAmount" => null,
                "quickConfig"=> "",
                "quickConfigList"=> [
                    [
                        "rechargeAmount"=> 100,
                        "giftAmount"=> 0
                    ],
                    [
                        "rechargeAmount"=> 500,
                        "giftAmount"=> 0
                    ],
                    [
                        "rechargeAmount"=> 1000,
                        "giftAmount"=> 0
                    ],
                    [
                        "rechargeAmount"=> 5000,
                        "giftAmount"=> 0
                    ],
                    [
                        "rechargeAmount"=> 10000,
                        "giftAmount"=> 0
                    ],
                    [
                        "rechargeAmount"=> 50000,
                        "giftAmount"=> 0
                    ]
                ]
            ],
            [
                "payTypeID" => 1024,
                "payID" => 2,
                "payName" => "wepay",
                "paySysName" => "923",
                "miniPrice" => 200.00,
                "maxPrice" => 50000.00,
                "scope" => "100|300|500|1000|5000|10000",
                "paySendUrl" => "https://pocowin.com/pay/wepay",
                "parameters" => "",
                "startTime" => "00:00",
                "endTime" => "24:00",
                "rechargeRifts" => 0.0000,
                "c2cUnitAmount" => null,
                "quickConfig"=> "",
                "quickConfigList"=> [
                    [
                        "rechargeAmount"=> 100,
                        "giftAmount"=> 0
                    ],
                    [
                        "rechargeAmount"=> 500,
                        "giftAmount"=> 0
                    ],
                    [
                        "rechargeAmount"=> 1000,
                        "giftAmount"=> 0
                    ],
                    [
                        "rechargeAmount"=> 5000,
                        "giftAmount"=> 0
                    ],
                    [
                        "rechargeAmount"=> 10000,
                        "giftAmount"=> 0
                    ],
                    [
                        "rechargeAmount"=> 50000,
                        "giftAmount"=> 0
                    ]
                ]
            ]
        ]
    ];
} elseif ($payID == 11) {
    $responseData = [
        "rechargetypelist" => [
           [
                "payTypeID" => 10138,
                "payID" => 11,
                "payName" => "UPAY-USDT",
                "paySysName" => "",
                "miniPrice" => 1.00,
                "maxPrice" => 10000.00,
                "scope" => "10|30|50|100|500|1000",
                "paySendUrl" => "https://pocowin.com/pay/usdt",
                "parameters" => "",
                "startTime" => "00:00",
                "endTime" => "24:00",
                "rechargeRifts" => 0.0000,
                "c2cUnitAmount" => null,
                "quickConfig"=> "",
                "quickConfigList"=> [
                    [
                        "rechargeAmount"=> 10,
                        "giftAmount"=> 0
                    ],
                    [
                        "rechargeAmount"=> 50,
                        "giftAmount"=> 0
                    ],
                    [
                        "rechargeAmount"=> 100,
                        "giftAmount"=> 0
                    ],
                    [
                        "rechargeAmount"=> 500,
                        "giftAmount"=> 0
                    ],
                    [
                        "rechargeAmount"=> 1000,
                        "giftAmount"=> 0
                    ],
                    [
                        "rechargeAmount"=> 50000,
                        "giftAmount"=> 0
                    ]
                ]
            ]
        ]
    ];
} else {
    exit(json_encode([
        "code" => 1,
        "msg" => "Invalid payID"
    ]));
}

$response = [
    "data" => $responseData,
    "code" => 0,
    "msg" => "Succeed",
    "msgCode" => 0,
    "serviceNowTime" => date('Y-m-d H:i:s')
];

header('Content-Type: application/json');

echo json_encode($response);
?>
